﻿//////////////////////////////////////////////
// ScriptManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Script ;
}

/// Includes ---------------------------------

// nkScripts
#include "../Dll/DllDefines.h"

// nkCommon
#include <nilkinsCommon/Patterns/SingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <string>
#include <unordered_map>

/// Class ------------------------------------

namespace nkScripts
{
	class DLL_SCRIPTS_EXPORT ScriptManager final : public nkCommon::SingletonClass<ScriptManager>
	{
		public :

			// Memory management
			Script* createOrRetrieve (nkMemory::StringView name) ;
			Script* get (nkMemory::StringView name) ;
			Script* getByIndex (unsigned int id) ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;

		private :

			// Functions
			// Constructor, destructor
			ScriptManager () noexcept ;
			ScriptManager (const ScriptManager&) = delete ;
			virtual ~ScriptManager () ;

			// Operators
			ScriptManager& operator= (const ScriptManager&) = delete ;

		private :

			// Attributes
			std::unordered_map<std::string, nkMemory::UniquePtr<Script>> _scriptMap ;

		private :

			friend class nkCommon::SingletonClass<ScriptManager> ;
	} ;
}